********************************
* This program was run on my PC
* The age restriction can be changed to test the robustness of the results to doing it this way.
*******************************
version 10
clear
program drop _all
set mem 50m
set matsize 800
set more off

**********************************************************
* Here, we calculate pre-tax and post-tax inequality measures for 1977-2003
* Note that this is based on the files cps_posttax1977 to 2003
**********************************************************
program define calculate_inequality

if cpsyear<=1988 & year>=1977 {
ren _miggen interstatemover
recode interstatemover 4=1 0=. 8=. *=0
la var interstatemover "Moved from another state - missing if mvd from abroad"
}
if cpsyear>=1989 {
ren migmtr interstatemover
recode interstatemover 4/6=1 7/9=. *=0
la var interstatemover "Moved from another state - missing if mvd from abroad"
}

gen wagehr=_incwag/(hrslyr*_wkslyr)
replace wagehr=. if wagehr<index
replace wagehr=100*index if wagehr>(100*index) & wagehr~=.
gen atr=1-(faminc_posttax/faminc)
replace atr=. if atr>1 | atr<-1
gen wagehrpt=wagehr*(faminc_posttax/faminc) if atr~=.

* Change age restriction here
keep if age>15 & age<56 & wagehr~=.
*keep if age>24 & age<56 & wagehr~=.

drop inc* _* hhid* age child* marital*
for any gini sg125 sg15 sg25 sg35 wagemover samplesize: gen X=. \ gen Xpt=.
compress
levels state, local(state)
di "`state'"
foreach s of local state {
* ineqdeco wagehr [aw = wgt] if state == `s'
* replace gini = $S_gini if state == `s'
* ineqdeco wagehrpt [aw = wgt] if state == `s'
* replace ginipt = $S_gini if state == `s'
 sort state wagehr 
 gen n=_n if state == `s'
 egen temp1=min(n)
 replace n=n-temp1+1
 egen temp2=max(n)
 gen N=temp2
 drop temp*

 egen temp1=sum(wagehr) if state == `s'
 gen temp2=(((N-n+1)^1.25)-((N-n)^1.25))*wagehr if state == `s'
 egen temp3=sum(temp2) if state == `s'
 egen temp4=mean(wagehr) if state == `s'
 replace sg125=1-((1/(temp4*(N^1.25)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^1.5)-((N-n)^1.5))*wagehr if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace sg15=1-((1/(temp4*(N^1.5)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2)-((N-n)^2))*wagehr if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace gini=1-((1/(temp4*(N^2)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2.5)-((N-n)^2.5))*wagehr if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace sg25=1-((1/(temp4*(N^2.5)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^3.5)-((N-n)^3.5))*wagehr if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace sg35=1-((1/(temp4*(N^3.5)))*temp3) if state == `s'
 replace samplesize=N if state==`s'
 drop temp* n N

 sort state wagehrpt
 gen n=_n if state == `s' & wagehrpt~=.
 egen temp1=min(n)
 replace n=n-temp1+1
 egen temp2=max(n)
 gen N=temp2
 drop temp*

 egen temp1=sum(wagehrpt) if state == `s'
 egen temp4=mean(wagehrpt) if state == `s'
 gen temp2=(((N-n+1)^1.25)-((N-n)^1.25))*wagehrpt if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace sg125pt=1-((1/(temp4*(N^1.25)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^1.5)-((N-n)^1.5))*wagehrpt if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace sg15pt=1-((1/(temp4*(N^1.5)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2)-((N-n)^2))*wagehrpt if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace ginipt=1-((1/(temp4*(N^2)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^2.5)-((N-n)^2.5))*wagehrpt if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace sg25pt=1-((1/(temp4*(N^2.5)))*temp3) if state == `s'
 drop temp2 temp3 
 gen temp2=(((N-n+1)^3.5)-((N-n)^3.5))*wagehrpt if state == `s'
 egen temp3=sum(temp2) if state == `s'
 replace sg35pt=1-((1/(temp4*(N^3.5)))*temp3) if state == `s'
 egen tempmover1=mean(wagehr) if interstatemover==1 & state == `s'
 replace wagemover=tempmover1 if state == `s'
 egen tempmover2=mean(wagehrpt) if interstatemover==1 & state == `s'
 replace wagemoverpt=tempmover2 if state == `s'
 replace samplesizept=N if state==`s'
 drop temp* n N
}
collapse year cpsyear gini* sg* wage* faminc* samplesize* atr, by(state)
end

***********************************************************
* Creating inequality measures year-by-year from the March CPS
* (Note that we have 2 year variables, cpsyear, and earnings year=cpsyear-1)
**********************************************************
cd "C:\Users\Andrew\State & local tax progressivity\" 
for Y in num 1977/2002 \ X in num 17607.04 19262.67 21217.16 22623.83 24542.5 25884.16 26885.94 29240.22 30658.91 32368.86 33844.87 35602.16 37764.64 38640.56 39202.21 40243.89 41241.48 43098.48 47464.73 49595.78 52432.28 54749.87 56630.34 60715.47 64232.86 64150.74: use cps_posttaxY, clear \ gen index=X/65644 \ calculate_inequality \ drop cpsyear \ la var year "Earnings year" \ sort year \ save cps_ineqY.dta, replace
